import numpy as np
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
import sys
from matplotlib.patches import FancyBboxPatch
from matplotlib.colors import Normalize
import matplotlib.patheffects as path_effects

# Box properties for annotations
props = dict(boxstyle='round,pad=0.5,rounding_size=0.2', facecolor='white', alpha=1.0)

# Set the font size globally
plt.rcParams.update({'font.size': 20})
NumberTimeSteps = 10000
ave_step_size = 200
f = 13.56e6
dt = (1.0 / NumberTimeSteps / f)
NumberTimeStepsAveraged = int(NumberTimeSteps / ave_step_size)
dt2 = (1.0 / NumberTimeStepsAveraged / f)
Time2 = np.zeros(NumberTimeStepsAveraged)
for t in range(NumberTimeStepsAveraged):
    Time2[t] = dt2 * t

print(len(Time2))

def density_plot2(pack, titles, x_label, y_label, colors, plot_name, markers, line_styles, o2_percentages_list):
    # Only change: increase vertical dimension to improve layout
    fig, axes = plt.subplots(nrows=2, ncols=3, figsize=(20, 12), sharex=False)
    density_labels = [r'n$_e$', r'n$_{i,+}$', r'n$_{i,-}$']
    profile_labels1 = ["a)", "b)", "c)"]
    profile_labels2 = ["d)", "e)", "f)"]
    #colorpanel = ['#00FFFF', '#FFFF00', 'green']
    colorpanel = ['red', 'green', 'blue']
    ranges_pack = len(pack)
    t = [5400, 6200, 7000]
    unique_o2_percentages = sorted(set(o2 for o2_list in o2_percentages_list for o2 in o2_list))
    
    # Normalization for contour plot (adjust vmin/vmax if needed)
    norm = Normalize(vmin=-1, vmax=1)
    
    for idx in range(3):
        ax_contour1 = axes[0, idx]
        # pack[0] is parameterstudy 600 pack[1] is parameterstudy 700
        rho1 = pack[0]
        
        # Normalize data to 1e6 (MegaV/m)
        rho1[idx] /= 1e6
        
        x_axis = np.arange(rho1[idx].shape[0]) * dt * 1e9  # in ns
        y_axis = np.linspace(0, 1, rho1[idx].shape[1])
        
        # Use "turbo" colormap with normalization for a similar look as your good plot
        im1 = ax_contour1.contourf(x_axis, y_axis, rho1[idx].T, levels=61, cmap='seismic', norm=norm)
        contour = ax_contour1.contour(x_axis, y_axis, rho1[idx].T, levels=61, colors='black', linewidths=0.3)
        ax_contour1.set_title(f'{unique_o2_percentages[idx]}% O$_2$', fontsize=20)
        if idx == 0: ax_contour1.set_ylabel('x [mm]', fontsize=20)

        ax_contour1.set_xlabel('t$\,$[ns]', fontsize=20)
        cbar = fig.colorbar(im1, ax=ax_contour1, pad = 0.01)
        
        if idx == 0: cbar.set_ticks(np.linspace(-1,1,6))
        if idx == 1: cbar.set_ticks(np.linspace(-1,1,6))
        if idx == 2: cbar.set_ticks(np.linspace(-0.8,0.8,5))

        ax_contour1.text(0.99, 1.02, r'E$\,$[$10^6\,$Vm$^{-1}$]', transform=ax_contour1.transAxes, ha='center', fontsize=20)
        
        # Set x-axis limits and ticks for improved distribution
        ax_contour1.set_xlim(0,70)
        ax_contour1.set_xticks([0,10,20,30,40,50,60,70])
        

        
        # Vertical lines for snapshots
        for i in range(len(t)):
            marker = markers[i % len(markers)]
            linestyle = line_styles[i % len(line_styles)]
            ti = round(1e9 * dt * t[i], 2)
            ax_contour1.axvline(x=ti, color=colorpanel[i], linestyle=linestyle, linewidth=3)

        ## Density profile subplot for 600 V
        ax_profilet1 = axes[1, idx]
        for i in range(3):
            marker = markers[i % len(markers)]
            linestyle = line_styles[i % len(line_styles)]
            ti = round(1e9 * dt * t[i], 1)
            ax_profilet1.plot(np.linspace(0, 1, rho1[idx].shape[1]),
                              rho1[idx][t[i], :] * 1e3, color=colorpanel[i],
                              linewidth=3, linestyle=linestyle, marker=marker, markevery=20, markersize=5, label=str(ti) + "$\,$ns")
        ax_profilet1.set_xlim(0.3, 0.9)
        #ax_profilet1.set_facecolor('lightgrey')
        ax_profilet1.grid(True)
        #o2 = unique_o2_percentages[idx]
        #ax_profilet1.set_title(f'{o2}% O$_2$', fontsize=18)
        if idx == 0:
            ax_profilet1.set_ylabel(r'E$\,$[kVm$^{-1}$]', fontsize=20)
        if idx != 2:
            ax_profilet1.set_ylim(-225, -100)
        else:
            ax_profilet1.set_ylim(-300, -100)
        #ax_profilet1.legend(loc='lower right', fontsize=20)
        ax_profilet1.text(0.91, 0.95, profile_labels2[idx], transform=ax_profilet1.transAxes, fontsize=20, va='top', bbox=props)
        ax_contour1.text(0.89, 0.95, profile_labels1[idx], transform=ax_contour1.transAxes, fontsize=20, va='top', bbox=props)
        ax_profilet1.set_xlabel(x_label, fontsize=20)
        #ax_contour1.tick_params(labelsize=16)
        #ax_profilet1.tick_params(labelsize=16)
    
    
    handles, labels = ax_profilet1.get_legend_handles_labels()
    fig.legend(handles, labels, loc='upper center', bbox_to_anchor=(0.5, 1.0), ncol=3, fontsize=20, columnspacing=0.5)



    fig.tight_layout(rect=[0, 0, 1, 0.95])
    #plt.show()
    fig.savefig(plot_name, bbox_inches='tight')
    plt.close(fig)

def load_data(path):
    data_Efield = np.loadtxt(f'{path}/ReportDataElectricFieldXT.out')
    return data_Efield

# Load your data
#field_600_005 = load_data('600pp/0.05')
#field_600_01 = load_data('600pp/0.1')
#field_600_05 = load_data('600pp/0.5')

field_700_005 = load_data('700pp/0.05')
field_700_01 = load_data('700pp/0.1')
field_700_05 = load_data('700pp/0.5')
#pack_field_600 = [field_600_005, field_600_01, field_600_05]
pack_field_700 = [field_700_005, field_700_01, field_700_05]
#pack_pack_field = [pack_field_600, pack_field_700]
pack_pack_field = [pack_field_700]
colors = ['red', 'green', 'blue']
markers = ['o', 's', '^', 'D', 'v', '>', '<', 'p']
line_styles = ['-', '--', '-.', ':', (0, (5, 1)), (0, (3, 1, 1, 1))]

o2_percentages_600 = [0.05, 0.1, 0.5]
o2_percentages_700 = [0.05, 0.1, 0.5]
titles = [r'600 V$_{pp}$', r'700 V$_{pp}$']
o2_percentages_list = [o2_percentages_600, o2_percentages_700]

density_plot2(pack_pack_field, titles, 'x [mm]', r'n [m$^{-3}$]',
              colors, 'field_plot_group_contours_and_snaps_paper_final700.png', markers, line_styles, o2_percentages_list)
