import numpy as np
import matplotlib.pyplot as plt
import matplotlib 
import matplotlib.gridspec as gridspec # GRIDSPEC !
from numpy import *

from matplotlib.colorbar import Colorbar # For dealing with Colorbars the proper way - TBD in a separate PyCoffee ?
from matplotlib.ticker import MaxNLocator,FormatStrFormatter
from matplotlib.colors import Normalize
import sys
import os
# Create a single colorbar for all plots
from mpl_toolkits.axes_grid1 import make_axes_locatable



class MidpointNormalize(Normalize):
    def __init__(self, vmin=None, vmax=None, midpoint=None, clip=False):
        self.midpoint = midpoint
        Normalize.__init__(self, vmin, vmax, clip)

    def __call__(self, value, clip=None):
        # I'm ignoring masked values and all kinds of edge cases to make a
        # simple example...
        x, y = [self.vmin, self.midpoint, self.vmax], [0, 0.5, 1]
        return np.ma.masked_array(np.interp(value, x, y))

norm = MidpointNormalize(midpoint=0)

matplotlib.rc("font", family="serif")
matplotlib.rc("font", size=18)

me = 9.10938356e-31
ele=1.6e-19



exec1_600pp_sim = np.loadtxt("600pp_sim/ExecRateHeMetaXT (1_600pp).out")
exec2_600pp_sim = np.loadtxt("600pp_sim/ExecRateHeMetaXT (2_600pp).out")
exec3_600pp_sim = np.loadtxt("600pp_sim/ExecRateHeMetaXT (0_600pp).out")
exec4_600pp_sim = np.loadtxt("600pp_sim/ExecRateHeMetaXT (3_600pp).out")

exec1_700pp_sim = np.loadtxt("700pp_sim/ExecRateHeMetaXT(0.05).out")
exec2_700pp_sim = np.loadtxt("700pp_sim/ExecRateHeMetaXT(0.1).out")
exec3_700pp_sim = np.loadtxt("700pp_sim/ExecRateHeMetaXT(0.2).out")
exec4_700pp_sim = np.loadtxt("700pp_sim/ExecRateHeMetaXT(0.5).out")

exec1_600pp_exp = np.loadtxt("600pp_exp/Eval856_1.dat")
exec2_600pp_exp = np.loadtxt("600pp_exp/Eval859_1.dat")
exec3_600pp_exp = np.loadtxt("600pp_exp/Eval862_1.dat")
exec4_600pp_exp = np.loadtxt("600pp_exp/Eval865_1.dat")

exec1_700pp_exp = np.loadtxt("700pp_exp/Eval855_1.dat")
exec2_700pp_exp = np.loadtxt("700pp_exp/Eval858_1.dat")
exec3_700pp_exp = np.loadtxt("700pp_exp/Eval861_1.dat")
exec4_700pp_exp = np.loadtxt("700pp_exp/Eval864_1.dat")
#normalize experimental data
exec1_600pp_exp = exec1_600pp_exp/np.max(exec1_600pp_exp)
exec2_600pp_exp = exec2_600pp_exp/np.max(exec2_600pp_exp)
exec3_600pp_exp = exec3_600pp_exp/np.max(exec3_600pp_exp)
exec4_600pp_exp = exec4_600pp_exp/np.max(exec4_600pp_exp)

exec1_700pp_exp = exec1_700pp_exp/np.max(exec1_700pp_exp)
exec2_700pp_exp = exec2_700pp_exp/np.max(exec2_700pp_exp)
exec3_700pp_exp = exec3_700pp_exp/np.max(exec3_700pp_exp)
exec4_700pp_exp = exec4_700pp_exp/np.max(exec4_700pp_exp)




#exec1_500pp_sim = np.loadtxt("500pp_sim/ExecRateHeMetaXT(0.05).out")
#exec2_500pp_sim = np.loadtxt("500pp_sim/ExecRateHeMetaXT(0.1).out")
#exec3_500pp_sim = np.loadtxt("500pp_sim/ExecRateHeMetaXT(0.2).out")
#exec4_500pp_sim = np.loadtxt("500pp_sim/ExecRateHeMetaXT(0.5).out")

#exec1_500pp_exp = np.loadtxt("500pp_exp/Eval895_1.dat")


NumberTimeSteps = len(exec1_600pp_sim[1,:])
NumberGridPoints = len(exec1_600pp_sim[:,1])
f = 13.56e6
dt = (1.0/NumberTimeSteps/f)
T= 1.0/f
L=1e-3 # gapdistance
dx = L/(NumberGridPoints-1)

#####################################
##### Averaging of time steps #######
ave_step_size = 200
NumberTimeStepsAveraged =int( NumberTimeSteps/ave_step_size)
exec1_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec2_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec3_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec4_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)

exec5_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec6_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec7_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec8_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)

exec9_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec10_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec11_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)
exec12_av = np.zeros((NumberGridPoints,NumberTimeStepsAveraged),float)



dt2 = (1.0/NumberTimeStepsAveraged/f)
Time2 = np.zeros(NumberTimeStepsAveraged)
for t in range(NumberTimeStepsAveraged):
    Time2[t] = dt2*t
def binning_function(target_data,original_data,ave_step_size):
    for i in range(NumberTimeSteps):
            t2 = int(i/ave_step_size)
            target_data[0:NumberGridPoints+1,t2] += original_data[0:NumberGridPoints+1,i]/ave_step_size
    return target_data


#600pp sim
exec1_av = binning_function(exec1_av,exec1_600pp_sim,ave_step_size)
exec1_av = exec1_av/np.max(exec1_av)
exec2_av = binning_function(exec2_av,exec2_600pp_sim,ave_step_size)
exec2_av = exec2_av/np.max(exec2_av)
exec3_av = binning_function(exec3_av,exec3_600pp_sim,ave_step_size)
exec3_av = exec3_av/np.max(exec3_av)
exec4_av = binning_function(exec4_av,exec4_600pp_sim,ave_step_size)
exec4_av = exec4_av/np.max(exec4_av)
#700pp sim
exec5_av = binning_function(exec5_av,exec1_700pp_sim,ave_step_size)
exec5_av = exec5_av/np.max(exec5_av)
exec6_av = binning_function(exec6_av,exec2_700pp_sim,ave_step_size)
exec6_av = exec6_av/np.max(exec6_av)
exec7_av = binning_function(exec7_av,exec3_700pp_sim,ave_step_size)
exec7_av = exec7_av/np.max(exec7_av)
exec8_av = binning_function(exec8_av,exec4_700pp_sim,ave_step_size)
exec8_av = exec8_av/np.max(exec8_av)


#exec9_av = binning_function(exec9_av,exec1_500pp_sim,ave_step_size)
#exec10_av = binning_function(exec10_av,exec2_500pp_sim,ave_step_size)
#exec11_av = binning_function(exec11_av,exec3_500pp_sim,ave_step_size)



#####################################
#####################################


# determine spatial resolution from number of pixels spanning the 1 mm gap
print(np.shape(exec1_600pp_exp))
print(exec1_600pp_exp.shape[0])
print(exec1_600pp_exp.shape[1])
n_pixels = exec1_600pp_exp.shape[0]
print(f"Number of pixels: {n_pixels}")
resolution_mm_per_pixel = 1.0 / n_pixels  # mm per pixel
print(f"Spatial resolution: {resolution_mm_per_pixel*1e3:.1f} µm/pixel")


Time = np.zeros(NumberTimeSteps)    
Grid = np.zeros(NumberGridPoints) 



for t in range(NumberTimeSteps):
    Time[t] = dt*t
for x in range(NumberGridPoints):
    Grid[x] = dx*x

Grid = Grid*1e3
Time = Time*1e9

# do a row of plots for the excitation rate
fig = plt.figure(figsize=(16, 16))  # Increase the figure size
# i want four plots in a row in one 
gs = gridspec.GridSpec(4, 4, width_ratios=[1,1,1,1])



ts_grid_exp = np.shape(exec1_600pp_exp)
#ts_grid_exp_500pp = np.shape(exec1_500pp_exp)
#time_exp_500pp = np.arange(0,ts_grid_exp_500pp[1],1)
#grid_exp_500pp = np.arange(0,ts_grid_exp_500pp[0],1)*5e-3

range = 42-5
#time_exp = np.arange(0,ts_grid_exp[1],1)
time_exp = np.linspace(0,T,range)
grid_exp = np.arange(0,ts_grid_exp[0],1)*5e-3
dummy = np.zeros((ts_grid_exp[0],ts_grid_exp[1]),float)



###############################################################################################################
############################################### 500 pp ########################################################
###############################################################################################################
# 500pp sim 
#ax17 = plt.subplot(gs[0,0])
#ax18 = plt.subplot(gs[0,1])
#ax19 = plt.subplot(gs[0,2])
#ax20 = plt.subplot(gs[0,3])
##500pp exp
#ax21 = plt.subplot(gs[1,0])
#ax22 = plt.subplot(gs[1,1])
#ax23 = plt.subplot(gs[1,2])
#ax24 = plt.subplot(gs[1,3])
t1=int(29*1)
t2=int(59*1)
t3=int(89*1)
dummy1 = np.zeros((len(Time2),len(Grid)),float)
t = [int(Time[t1]), int(Time[t2]), int(Time[t3])]
labels = ["a)", "b)", "c)", "d)", "e)", "f)", "g)", "h)", "i)", "j)", "k)", "l)", "m)", "n)", "o)", "p)"]
print(len(labels))
print(Time[5400]*1e-9,Time[6200]*1e-9,Time[7000]*1e-9)


t= [5400, 6000, 7000]
###############################################################################################################
############################################### 600 pp ########################################################
###############################################################################################################
from matplotlib.patches import FancyBboxPatch

props = dict(boxstyle='round,pad=0.5,rounding_size=0.2', facecolor='white', alpha=1.0)

# Simulation 600pp sim
ax1 = plt.subplot(gs[0,0])
ax1.text(0.88, 0.96, rf""+str(labels[0]), transform=ax1.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax2 = plt.subplot(gs[0,1])
ax2.text(0.88, 0.96, rf""+str(labels[1]), transform=ax2.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax3 = plt.subplot(gs[0,2])
ax3.text(0.88, 0.96, rf""+str(labels[2]), transform=ax3.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax4 = plt.subplot(gs[0,3])
ax4.text(0.88, 0.96, rf""+str(labels[3]), transform=ax4.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)

ax1.axvline(x=Time2[27], ymin=0, ymax=1, linestyle='dashed', color='white',linewidth = 2.5)   # Draw vertical dashed white line
ax1.axvline(x=Time2[31], ymin=0, ymax=1, linestyle='dashed', color='white',linewidth = 2.5)  # Draw vertical dashed white line
ax1.axvline(x=Time2[35], ymin=0, ymax=1, linestyle='dashed', color='white',linewidth = 2.5) # Draw vertical dashed white line
print(Time2[27], Time2[30], Time2[33])
# Experiment 600pp exp
ax5 = plt.subplot(gs[1,0])
ax5.text(0.88, 0.96, rf""+str(labels[4]),  transform=ax5.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax6 = plt.subplot(gs[1,1])
ax6.text(0.88, 0.96, rf""+str(labels[5]),  transform=ax6.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax7 = plt.subplot(gs[1,2])
ax7.text(0.88, 0.96, rf""+str(labels[6]),  transform=ax7.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax8 = plt.subplot(gs[1,3])
ax8.text(0.88, 0.96, rf""+str(labels[7]),  transform=ax8.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)


ax1.set_title(r"0.05%" )#, pad=20)
ax2.set_title(r"0.1%"  )#, pad=20)
ax3.set_title(r"0.2%"  )#, pad=20)
ax4.set_title(r"0.5%"  )#, pad=20)
############################################################ Simulation 600pp

CAX1 = ax1.contourf(Time2,Grid,exec1_av,101, cmap=plt.cm.jet)#,norm=norm)
ax1.set_ylabel(r"$x\,$[mm]     Sim.")
ax1.set_xticks([])
ax1.set_yticks(np.arange(0,1.2,0.2))
ax1.set_ylim(0,1)
#cbar1 = fig.colorbar(CAX1, orientation="vertical", pad=0.02)
#cbar1.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX2 = ax2.contourf(Time2,Grid,exec2_av,101, cmap=plt.cm.jet)#,norm=norm)
#ax2.set_xlabel(r"t [ns]")
ax2.set_yticks([])
ax2.set_xticks([])
ax2.set_ylim(0,1)
#cbar2 = fig.colorbar(CAX2, orientation="vertical", pad=0.02)
#cbar2.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX3 = ax3.contourf(Time2,Grid,exec3_av,101, cmap=plt.cm.jet)#,norm=norm)
#ax3.set_xlabel(r"t [ns]")
ax3.set_yticks([])
ax3.set_xticks([])
ax3.set_ylim(0,1)
#cbar3 = fig.colorbar(CAX3, orientation="vertical", pad=0.02)
#cbar3.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX4 = ax4.contourf(Time2,Grid,exec4_av,101, cmap=plt.cm.jet)#,norm=norm)
#ax4.set_xlabel(r"t [ns]")
ax4.set_yticks([])
ax4.set_xticks([])
ax4.set_ylim(0,1)
#cbar4 = fig.colorbar(CAX4, orientation="vertical", pad=0.02)
#cbar4.set_ticks([0,0.2,0.4,0.6,0.8,1])
#################################################  Experiment 600pp

CAX5 = ax5.contourf(time_exp,grid_exp,exec2_600pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax5.set_ylabel(r"$x\,$[mm]     Exp.")
ax5.set_xticks([])
ax5.set_xticks([])
ax5.set_yticks(np.arange(0,1.2,0.2))
ax5.set_ylim(0,1)
#cbar5 = fig.colorbar(CAX5, orientation="vertical", pad=0.02)
#cbar5.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX6 = ax6.contourf(time_exp,grid_exp,exec1_600pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)

ax6.set_yticks([])
ax6.set_xticks([])
ax6.set_ylim(0,1)
#cbar6 = fig.colorbar(CAX6, orientation="vertical", pad=0.02)
#cbar6.set_ticks([0,0.2,0.4,0.6,0.8,1])

#copy exec3_600pp_exp[:,5:range+5] to dummy
dummy = exec3_600pp_exp[:,5:range+5]
dummy = dummy/np.max(dummy)
CAX7 = ax7.contourf(time_exp,grid_exp,dummy,101, cmap=plt.cm.jet)#,norm=norm)
ax7.set_xticks([])
ax7.set_yticks([])
ax7.set_ylim(0,1)
#cbar7 = fig.colorbar(CAX7, orientation="vertical", pad=0.02)
#cbar7.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX8 = ax8.contourf(time_exp,grid_exp,exec4_600pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax8.set_xticks([])
ax8.set_yticks([])
ax8.set_ylim(0,1)
#cbar8 =fig.colorbar(CAX8, orientation="vertical", pad=0.02)
#cbar8.set_ticks([0,0.2,0.4,0.6,0.8,1])





###############################################################################################################
############################################### 700 pp ########################################################
###############################################################################################################



# Simulation 700pp exp
ax9 = plt.subplot(gs[2,0])
ax9.text(0.89, 0.96, rf""+str(labels[8]), transform=ax9.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax10 = plt.subplot(gs[2,1])
ax10.text(0.885, 0.96, rf""+str(labels[9]), transform=ax10.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax11 = plt.subplot(gs[2,2])
ax11.text(0.88, 0.96, rf""+str(labels[10]), transform=ax11.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax12 = plt.subplot(gs[2,3])
ax12.text(0.88, 0.96, rf""+str(labels[11]), transform=ax12.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)



ax13 = plt.subplot(gs[3,0])
ax13.text(0.85, 0.96, rf""+str(labels[12]), transform=ax13.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax14 = plt.subplot(gs[3,1])
ax14.text(0.88, 0.96, rf""+str(labels[13]), transform=ax14.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax15 = plt.subplot(gs[3,2])
ax15.text(0.87, 0.96, rf""+str(labels[14]),transform=ax15.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)
ax16 = plt.subplot(gs[3,3])
ax16.text(0.87, 0.96, rf""+str(labels[15]), transform=ax16.transAxes, fontsize=14, va='top', backgroundcolor='1.0', alpha=1.0, bbox=props)

############################################################ Simulation 700pp



CAX9 = ax9.contourf(Time2,Grid,exec5_av,101, cmap=plt.cm.jet)#,norm=norm)# 700pp sim
ax9.set_ylabel(r"$x\,$[mm]     Sim.")

ax9.set_yticks(np.arange(0,1.2,0.2))
ax9.set_xticks([])
ax9.set_ylim(0,1)
#cbar9 = fig.colorbar(CAX9, orientation="vertical", pad=0.02)
#cbar9.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX10 = ax10.contourf(Time2,Grid,exec6_av,101, cmap=plt.cm.jet)#,norm=norm)
ax10.set_xticks([])
ax10.set_yticks([])
ax10.set_ylim(0,1)
#cbar10 = fig.colorbar(CAX10, orientation="vertical", pad=0.02)
#cbar10.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX11 = ax11.contourf(Time2,Grid,exec7_av,101, cmap=plt.cm.jet)#,norm=norm)
ax11.set_xticks([])
ax11.set_yticks([])
ax11.set_ylim(0,1)
#cbar11 = fig.colorbar(CAX11, orientation="vertical", pad=0.02)
#cbar11.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX12 = ax12.contourf(Time2,Grid,exec8_av,101, cmap=plt.cm.jet)#,norm=norm)

ax12.set_yticks([])
ax12.set_xticks([])
ax12.set_ylim(0,1)
#cbar12 = fig.colorbar(CAX12, orientation="vertical", pad=0.02)
#cbar12.set_ticks([0,0.2,0.4,0.6,0.8,1])

###############################################################################################################


#################################################  Experiment 700pp
print(np.shape(time_exp))
CAX13 = ax13.contourf(time_exp*1e9,grid_exp,exec2_700pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax13.set_ylabel(r"$x\,$[mm]    Exp.")
ax13.set_xlabel(r"$t\,$[ns]")
ax13.set_yticks(np.arange(0,1.2,0.2))
ax13.set_ylim(0,1)
#cbar13 = fig.colorbar(CAX13, orientation="vertical", pad=0.02)
#cbar13.set_ticks([0,0.2,0.4,0.6,0.8,1])


CAX14 = ax14.contourf(time_exp*1e9,grid_exp,exec1_700pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax14.set_xlabel(r"$t\,$[ns]")
ax14.set_yticks([])
ax14.set_ylim(0,1)
#cbar14 = fig.colorbar(CAX14, orientation="vertical", pad=0.02)
#cbar14.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX15 = ax15.contourf(time_exp*1e9,grid_exp,exec3_700pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax15.set_xlabel(r"$t\,$[ns]")
ax15.set_yticks([])
ax15.set_ylim(0,1)
#cbar15 = fig.colorbar(CAX15, orientation="vertical", pad=0.02)
#cbar15.set_ticks([0,0.2,0.4,0.6,0.8,1])

CAX16 = ax16.contourf(time_exp*1e9,grid_exp,exec4_700pp_exp[:,5:range+5],101, cmap=plt.cm.jet)#,norm=norm)
ax16.set_xlabel(r"$t\,$[ns]")
ax16.set_yticks([])

ax16.set_ylim(0,1)
#cbar16 = fig.colorbar(CAX16, orientation="vertical", pad=0.02)
#cbar16.set_ticks([0,0.2,0.4,0.6,0.8,1])
#cbar16.ax.yaxis.set_major_formatter(FormatStrFormatter('%.1f'))
#ax1.set_title(r"Excitation rate 600pp")
#####################################################################
# Collect all axes into a list
all_axes = [ax1, ax2, ax3, ax4, ax5, ax6, ax7, ax8, ax9, ax10, ax11, ax12, ax13, ax14, ax15, ax16]

# Create the colorbar
# Collect all axes into a list
all_axes = [ax1, ax2, ax3, ax4, ax5, ax6, ax7, ax8, ax9, ax10, ax11, ax12, ax13, ax14, ax15, ax16]

# Adjust the layout to make space for the colorbar
plt.subplots_adjust(left=0.05, right=0.95, top=0.9, bottom=0.1, wspace=0.1, hspace=0.1)

# Define a new axis for the colorbar below the entire figure
cbar_ax = fig.add_axes([0.1, 0.02, 0.8, 0.03])  # [left, bottom, width, height]

# Create the colorbar
cbar = fig.colorbar(CAX1, cax=cbar_ax, orientation='horizontal')

# Set ticks and labels for the colorbar
cbar.set_ticks([0, 0.2, 0.4, 0.6, 0.8, 1])
#cbar.set_label("Excitation Rate")


















fig.text(0.975, 0.65, r'600 V$_{\rm{pp}}$', ha='center', fontsize=20, rotation=270)
fig.text(0.975, 0.25, r'700 V$_{\rm{pp}}$', ha='center', fontsize=20, rotation=270)

## the layout is too pressed, so we need to adjust the layout
plt.subplots_adjust(left=0.05, right=0.95, top=0.9, bottom=0.1, wspace=0.1, hspace=0.1) 
plt.savefig("FigExecRateExp.png",format="png",bbox_inches='tight',dpi=200)
#
#plt.show()
plt.close()